(*********************************************************************************
* Copyright: Bernecker+Rainer
* Author:    Mikael Regard
* Created:   May 13, 2019/8:21 AM 
* Updated:   Aug 19, 2019/09:00 AM
 *********************************************************************************
 * Description:
 * FuB to configure feedback stream Xbot.
 * 
 *Input:
 * MsgFrame  (Profinet output frame)
 * ReadFrame (Profinet reply frame)
 * Execute   (Edgepos, Execute = TRUE will run the FuB once)
 * Cmd Label (Optional 2 byte Command label. Used to identify specfic commands.)
 * NumOfConfig (Number of feedback streams slots to configure (from 1 to 8))
 * XbotID[0..7]   (Any positive integer represent a particular Xbot.)
 * StreamID[0..7] (StreamID Valid stream Ids are in the range of [0,10] ??)
 * FeedbackMode[0..7] (Feedback Mode (Bitmap) BIT structure [RZ,RY,RX,Z,Y,X])
 *
 *
 * Output:
 * Error (Indicates if there is an error)
 * Busy  (FuB will be Busy until reply)
 * Done  (When Accepted command is received, Done = TRUE) 
 * ErrorID (0x0001 = System Error, 0x2000 = Wrong PMC State, 0x2001 = No Mastership, 0x2002 = Mastership timeout,
 *		    0x2003 = Wrong group state, 0x2004 = Wrong Macro state, 0x2005 = Wrong Digital IO state,
 *          0x2006 = Wrong flyways state, 0x3000 = Wrong Xbot state, 0x4000 = Paramter Error: Invalid Parameters.
 *********************************************************************************)






FUNCTION_BLOCK PM_FeedbackStreamConfig		
	// Check Reply
	IF(Busy)THEN
		brsmemcpy(ADR(CmdLbl),ADR(ReadFrame[3]),2);
		IF(ReadFrame[0] = CmdCount AND
			ReadFrame[1] 	= 12  AND
			ReadFrame[2]	= 11 AND
			CmdLbl = CmdLabel)THEN
			Done 	:= TRUE;
			Busy 	:= FALSE;
			brsmemcpy(ADR(ErrorID),ADR(ReadFrame[5]),2);
			Error 	:= UINT_TO_BOOL(ErrorID);
			Done 	:= NOT(UINT_TO_BOOL(ErrorID));
		ELSE
			Busy := FALSE;
		END_IF;
	END_IF;
	//Send Command		
	IF(Execute AND NOT(Done) AND NOT(Error))THEN
		IF(NOT(Busy))THEN
			brsmemset(ADR(MsgFrame[1]),FALSE,98);
			CmdCount 		:= ReadFrame[0] +1;
			MsgFrame[0] 	:= CmdCount; 
			MsgFrame[1] 	:= 12;
			MsgFrame[2] 	:= 11;
			brsmemcpy(ADR(MsgFrame[3]), ADR(CmdLabel), 2);
			MsgFrame[5]		:= 1;
			MsgFrame[9]		:= NumOfConfig;
		
			FOR count := 0 TO NumOfConfig DO
				MsgFrame[11 + (FEEDBACKCONFIG_BYTE_SEQUENCE*count)] := XbotID [count];
				MsgFrame[12 + (FEEDBACKCONFIG_BYTE_SEQUENCE*count)] := StreamID [count];
				MsgFrame[13 + (FEEDBACKCONFIG_BYTE_SEQUENCE*count)] := FeedbackMode [count];   
			END_FOR;
			Busy := TRUE;	
		END_IF;
		//Reset Output
		
	ELSIF(NOT(Execute))THEN
		Busy := FALSE;
		Done := FALSE;
		Error := FALSE;
		ErrorID := 0;
	END_IF
	
	
	
END_FUNCTION_BLOCK
